# 画面設計書 45-フォームレイアウト（Bootstrap 3）

## 概要

本ドキュメントは、Symfony Twig Bridgeが提供するBootstrap 3対応のフォームレイアウトテーマ（bootstrap_3_layout.html.twig）の画面設計書である。bootstrap_base_layoutを基盤として、Bootstrap 3のCSSクラスを適用したフォーム要素のレンダリングを行う。

### 本画面の処理概要

**業務上の目的・背景**：Bootstrap 3はCSS/JavaScriptフレームワークとして広く利用されてきた。bootstrap_3_layoutは、Symfonyのフォームコンポーネントが生成するHTML要素にBootstrap 3のCSSクラス（form-control, form-group, has-error, btn, glyphicon等）を自動適用し、Bootstrap 3のデザインに準拠したフォームを手軽に構築できるようにする。

**画面へのアクセス方法**：Symfonyの設定で`twig.form_themes`に`'bootstrap_3_layout.html.twig'`を指定する。

**主要な操作・処理内容**：
1. テキスト入力にform-controlクラスを適用（file, hidden除く）
2. ボタンにbtn-defaultおよびbtnクラスを適用
3. 金額入力をinput-group/input-group-addonで通貨記号付きレイアウトに対応
4. チェックボックスをdiv.checkboxでラップ（checkbox-inlineクラスでインライン表示対応）
5. ラジオボタンをdiv.radioでラップ（radio-inlineクラスでインライン表示対応）
6. セレクト要素にform-controlクラスを適用
7. ラベルにcontrol-labelクラスを適用
8. フォーム行をdiv.form-groupでラップし、バリデーションエラー時にhas-errorクラスを付与
9. エラーメッセージをhelp-block/alert-dangerクラスのspan/divで表示、glyphiconアイコン付き
10. ヘルプテキストをhelp-blockクラスのspanで表示

**画面遷移**：本テーマファイル自体は画面遷移を定義しない。

**権限による表示制御**：テーマファイル自体には権限制御機能はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | Form | 主機能 | Bootstrap 3対応のフォームレイアウトテーマによるフォームレンダリング |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのフォームレンダリング拡張によるBootstrap 3用ブロック定義 |

## 画面種別

フォームテーマ（Twigテンプレート断片）

## URL/ルーティング

本テーマファイルは直接URLに紐づかない。

```yaml
twig:
    form_themes: ['bootstrap_3_layout.html.twig']
```

## 入出力項目

form_div_layoutと同一の共通変数に加え、以下のBootstrap 3固有変数を使用する。

| 変数名 | 型 | 説明 |
|--------|------|------|
| parent_label_class | string | 親ラベルのCSSクラス（checkbox-inline/radio-inline判定用） |
| valid | bool | バリデーション結果（falseでhas-errorクラス適用） |
| force_error | bool | エラー表示強制フラグ（choice, date, time, datetime行で使用） |
| widget | string | チェックボックス/ラジオのwidgetブロック出力（ラベル内に埋め込み） |

## 表示項目

### オーバーライドされた主要ブロック一覧

| ブロック名 | Bootstrap 3適用クラス | 説明 |
|-----------|---------------------|------|
| form_widget_simple | `form-control` | テキスト入力要素（file/hidden除く） |
| button_widget | `btn-default btn` | ボタン要素 |
| money_widget | `input-group` / `input-group-addon` | 通貨記号付き入力 |
| checkbox_widget | `checkbox` / `checkbox-inline` | チェックボックスラッパー |
| radio_widget | `radio` / `radio-inline` | ラジオボタンラッパー |
| choice_widget_collapsed | `form-control` | セレクト要素 |
| form_label | `control-label` | ラベル要素 |
| form_row_render | `form-group` / `has-error` | フォーム行ラッパー |
| button_row | `form-group` | ボタン行ラッパー |
| form_errors | `help-block` / `alert alert-danger` / `glyphicon glyphicon-exclamation-sign` | エラー表示 |
| form_help | `help-block` | ヘルプテキスト |
| checkbox_radio_label | - | チェックボックス/ラジオのラベル+ウィジェット統合表示 |

## イベント仕様

### 1-Bootstrap 3スタイルでのフォームレンダリング

form_div_layoutと同一のフォームヘルパー関数呼び出しにより、Bootstrap 3クラス付きHTMLが生成される。

主なHTML出力例：
```html
<!-- form_row -->
<div class="form-group has-error">
    <label class="control-label required" for="form_name">Name</label>
    <input type="text" class="form-control" id="form_name" name="form[name]" required="required" />
    <span class="help-text">Enter your full name</span>
    <span class="help-block">
        <ul class="list-unstyled">
            <li><span class="glyphicon glyphicon-exclamation-sign"></span> This value is required.</li>
        </ul>
    </span>
</div>
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォームレンダリング | なし | なし | テンプレートはHTMLレンダリングのみ |

## メッセージ仕様

form_div_layoutと同一。エラーメッセージはglyphiconアイコン付きで表示される。

## 例外処理

テーマテンプレート自体は例外をスローしない。

## 備考

- `{% use 'bootstrap_base_layout.html.twig' %}`により、bootstrap_base_layoutの全ブロックを基盤として利用
- bootstrap_base_layoutはform_div_layoutを基盤としているため、3層の継承構造になっている
- checkbox_radio_labelブロックでは、widgetの出力をlabel要素内に埋め込む独自のレンダリングを行う
- has-errorクラスは`(not compound or force_error|default(false)) and not valid`の条件で適用される
- choice_row, date_row, time_row, datetime_rowではforce_error=trueが設定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

FormViewの共通変数に加え、Bootstrap 3固有の変数を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FormView.php | `src/Symfony/Component/Form/FormView.php` | フォームビューの構造を理解する |

#### Step 2: 継承チェーンの基盤を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | 最も基盤となるテーマを理解する |
| 2-2 | bootstrap_base_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` | Bootstrap共通の基盤テーマ（textarea_widget, money_widget, datetime/date/time/dateinterval_widget等）を理解する |

#### Step 3: Bootstrap 3固有のオーバーライドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bootstrap_3_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_3_layout.html.twig` | Bootstrap 3固有のCSS クラス適用を理解する |

**主要処理フロー**:
1. **L5-10**: `form_widget_simple` - form-controlクラスの適用
2. **L12-15**: `button_widget` - btn-defaultおよびbtnクラスの適用
3. **L17-33**: `money_widget` - input-group/input-group-addonによる通貨記号表示
4. **L35-44**: `checkbox_widget` - div.checkboxラッパー、checkbox-inlineでインライン対応
5. **L46-55**: `radio_widget` - div.radioラッパー、radio-inlineでインライン対応
6. **L57-60**: `choice_widget_collapsed` - form-controlクラスの適用
7. **L64-67**: `form_label` - control-labelクラスの適用
8. **L87-126**: `checkbox_radio_label` - widget出力をlabel内に埋め込むロジック
9. **L130-137**: `form_row_render` - form-group + has-errorクラスの適用
10. **L183-193**: `form_errors` - help-block/alert-danger + glyphiconアイコンによるエラー表示
11. **L197-216**: `form_help` - help-blockクラスのspan要素

### プログラム呼び出し階層図

```
{{ form_row(form.field) }}
    |
    +-- form_row [form_div_layoutから継承]
    |       +-- aria属性の計算
    |       +-- form_row_render [bootstrap_3_layout オーバーライド]
    |               |
    |               +-- <div class="form-group has-error">
    |               +-- form_label [bootstrap_3_layout オーバーライド]
    |               |       +-- <label class="control-label">
    |               +-- form_widget [bootstrap_base_layoutから継承]
    |               |       +-- form_widget_simple [bootstrap_3_layout オーバーライド]
    |               |               +-- <input class="form-control" />
    |               +-- form_help [bootstrap_3_layout オーバーライド]
    |               |       +-- <span class="help-block">
    |               +-- form_errors [bootstrap_3_layout オーバーライド]
    |                       +-- <span class="help-block"><ul class="list-unstyled">
    |                       +-- <li><span class="glyphicon">
```

### データフロー図

```
[入力]                          [処理]                              [出力]

FormView ---------> TwigRendererEngine ---------> ブロック解決
                    テーマ検索順序:                     |
                    1. bootstrap_3_layout              v
                    2. bootstrap_base_layout     Bootstrap 3 CSSクラス付きHTML
                    3. form_div_layout           (<div class="form-group">,
                                                  <input class="form-control">,
                                                  <span class="help-block">, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bootstrap_3_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_3_layout.html.twig` | テンプレート | Bootstrap 3対応フォームテーマ（全217行） |
| bootstrap_base_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` | テンプレート | Bootstrap共通の基盤テーマ（全209行） |
| form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | テンプレート | 最も基盤となるフォームレイアウトテーマ（全482行） |
